package demo;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import demo.forms.*;

/**
 * Interroge la base de donnes pour trouver les informations 
 * recherches
*/
public class kb extends MIDlet implements IStateMachine {
  // Formulaire de requte
  private QueryForm queryForm;
  // Ecran de rsultat de la requte
  private QueryResultsList queryResultsList;
  // Ecran des dtails d'une information particulire
  private Details details;
  // Etat courant de l'application
  private int currentState;

  // Etats valides
  // L'tat Query correspond au cas o les utilisateurs peuvent 
  // interroger la base de donnes
  public static final int STATE_QUERY = 1;
  // L'tat Query Results correspond au cas o le rsultat de la 
  // requte de l'utilisateur est affiche
  public static final int STATE_QUERY_RESULTS = 2;
  // L'tat Details correspond au cas o les informations 
  // dtailles sont affiches
  public static final int STATE_DETAILS = 3;

  /**
   * Constructeur cre un nouveau kb dont l'tat initial est 
   * STATE_QUERY
   */
  public kb() {
    this.currentState = STATE_QUERY;
    this.queryForm = new QueryForm("Recherche", this);
    this.queryResultsList = new QueryResultsList("Rsultat", this);
    this.details = new Details("Dtails", this);
  }

  // Mthodes MIDlet

  // Dclenche stateUpdated() pour placer l'cran
  protected void startApp() {
    stateUpdated(null);
  }

  protected void destroyApp(boolean unconditional)
            throws MIDletStateChangeException {
  }

  protected void pauseApp() {
  }

  // Mthodes de IStateMachine

  /**
   * Modifie l'tat courant
   */
  public void setCurrentState(int newState, Object eventData) {
    this.currentState = newState;
    stateUpdated(eventData);
  }

  // Mthodes de manipulation de l'tat

  // Dcide quel objet Displayable activer avec Display et appelle 
  // handleTransition() avec l'tat cible
  private void stateUpdated(Object eventData) {
    Displayable displayable = null;
    switch (this.currentState) {
      case STATE_QUERY:
        displayable = this.queryForm;
        break;
      case STATE_QUERY_RESULTS:
        if (eventData != null) {
          this.queryResultsList = null;
          this.queryResultsList = new QueryResultsList("Rsultat", this);
          this.queryResultsList.handleTransition(eventData);
        }
        displayable = this.queryResultsList;
        break;
      case STATE_DETAILS:
        this.details = null;
        this.details = new Details("Dtails", this);
        this.details.handleTransition(eventData);
        displayable = this.details;
        break;
      default:
        displayable = this.queryForm;
        break;
    }
    Display.getDisplay(this).setCurrent(displayable);
  }
}
